<?php
/**
 * Outputs the Import and Export screen.
 *
 * @package WPZincDashboardWidget
 * @author WP Zinc
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

?>
<header>
	<h1>
		<?php echo esc_html( $this->plugin->displayName ); ?>

		<span>
			<?php esc_html_e( 'Import &amp; Export', $this->plugin->name ); // phpcs:ignore WordPress.WP.I18n ?>
		</span>
	</h1>
</header>

<hr class="wp-header-end" />

<div class="wrap">
	<div class="wrap-inner">
		<?php
		// Notices.
		if ( isset( $this->message ) && ! empty( $this->message ) ) {
			?>
			<div class="updated notice"><p><?php echo esc_html( $this->message ); ?></p></div>  
			<?php
		}
		if ( isset( $this->error_message ) && ! empty( $this->error_message ) ) {
			?>
			<div class="error notice"><p><?php echo esc_html( $this->error_message ); ?></p></div>  
			<?php
		}
		?>

		<!-- Tabs -->
		<h2 class="nav-tab-wrapper wpzinc-horizontal-tabbed-ui">
			<a href="<?php echo esc_url( $this->plugin->documentation_url ); ?>" class="nav-tab last documentation" rel="noopener" target="_blank">
				<?php esc_html_e( 'Documentation', $this->plugin->name ); // phpcs:ignore WordPress.WP.I18n ?>
				<span class="dashicons dashicons-admin-page"></span>
			</a>
		</h2>

		<form name="post" method="post" action="<?php echo ( isset( $_SERVER['REQUEST_URI'] ) ? esc_url_raw( wp_unslash( $_SERVER['REQUEST_URI'] ) ) : '' ); ?>" id="<?php echo esc_attr( $this->plugin->name ); ?>" enctype="multipart/form-data">
			<div id="poststuff">
				<div id="post-body" class="metabox-holder columns-1">
					<!-- Content -->
					<div id="post-body-content">
						<div id="normal-sortables" class="meta-box-sortables ui-sortable publishing-defaults">  
							<div class="postbox wpzinc-vertical-tabbed-ui">
								<!-- Second level tabs -->
								<ul class="wpzinc-nav-tabs wpzinc-js-tabs" data-panels-container="#import-export-container" data-panel=".panel" data-active="wpzinc-nav-tab-vertical-active">
									<li class="wpzinc-nav-tab download">
										<a href="#import" class="wpzinc-nav-tab-vertical-active">
											<?php esc_html_e( 'Import', $this->plugin->name ); // phpcs:ignore WordPress.WP.I18n ?>
										</a>
									</li>
									<?php
									if ( is_array( $import_sources ) && count( $import_sources ) > 0 ) {
										foreach ( $import_sources as $import_source ) {
											?>
											<li class="wpzinc-nav-tab <?php echo esc_attr( $import_source['name'] ); ?>">
												<a href="#<?php echo esc_attr( $import_source['name'] ); ?>">
													<?php echo esc_html( $import_source['label'] ); ?>
												</a>
											</li>
											<?php
										}
									}
									?>
									<li class="wpzinc-nav-tab upload">
										<a href="#export">
											<?php esc_html_e( 'Export', $this->plugin->name ); // phpcs:ignore WordPress.WP.I18n ?>
										</a>
									</li>
								</ul>

								<!-- Content -->
								<div id="import-export-container" class="wpzinc-nav-tabs-content">
									<!-- Import -->
									<div id="import" class="panel">
										<div class="postbox">
											<header>
												<h3><?php esc_html_e( 'Import', $this->plugin->name ); // phpcs:ignore WordPress.WP.I18n ?></h3>
												<p class="description">
													<?php esc_html_e( 'Upload a file generated by this Plugin\'s export functionality (JSON or zipped JSON).  This will overwrite any existing settings stored on this installation.', $this->plugin->name ); // phpcs:ignore WordPress.WP.I18n ?>
												</p>
											</header>

											<div class="wpzinc-option">
												<div class="left">
													<label for="file"><?php esc_html_e( 'JSON File', $this->plugin->name ); // phpcs:ignore WordPress.WP.I18n ?></label>
												</div>
												<div class="right">
													<input type="file" id="file" name="import" />
												</div>
											</div>

											<div class="wpzinc-option">
												<input name="import" type="submit" class="button button-primary" value="<?php esc_attr_e( 'Import', $this->plugin->name ); // phpcs:ignore WordPress.WP.I18n ?>" />              
											</div>
										</div>
									</div>

									<?php
									if ( is_array( $import_sources ) && count( $import_sources ) > 0 ) {
										foreach ( $import_sources as $import_source ) {
											include_once $import_source['view'];
										}
									}
									?>

									<!-- Export -->
									<div id="export" class="panel">
										<div class="postbox">
											<header>
												<h3><?php esc_html_e( 'Export', $this->plugin->name ); // phpcs:ignore WordPress.WP.I18n ?></h3>
												<p class="description">
													<?php esc_html_e( 'To export this Plugin\'s settings, choose which item(s) to export, and click the Export button below.', $this->plugin->name ); // phpcs:ignore WordPress.WP.I18n ?>
													<br />
													<?php esc_html_e( 'You can then import the generated file into another Plugin installation.', $this->plugin->name ); // phpcs:ignore WordPress.WP.I18n ?>
													<br />
													<?php esc_html_e( 'Including this file in a support request? We recommend setting the Format option to "Export as JSON, Zipped".', $this->plugin->name ); // phpcs:ignore WordPress.WP.I18n ?>
												</p>
											</header>

											<?php
											/**
											 * Add any form options to the Export screen
											 *
											 * @since   1.0.0
											 */
											do_action( str_replace( '-', '_', $this->plugin->name ) . '_export_view' ); // phpcs:ignore WordPress.NamingConventions.ValidHookName
											?>

											<div class="wpzinc-option">
												<div class="left">
													<label for="format"><?php esc_html_e( 'Format', $this->plugin->name ); // phpcs:ignore WordPress.WP.I18n ?></label>
												</div>
												<div class="right">
													<select name="format" id="format" size="1">
														<option value="json"><?php esc_html_e( 'JSON', $this->plugin->name ); // phpcs:ignore WordPress.WP.I18n ?></option>
														<option value="zip"><?php esc_html_e( 'JSON, Zipped', $this->plugin->name ); // phpcs:ignore WordPress.WP.I18n ?></option>
													</select>
												</div>
											</div>

											<div class="wpzinc-option">
												<input name="export" type="submit" class="button button-primary" value="<?php esc_attr_e( 'Export', $this->plugin->name ); // phpcs:ignore WordPress.WP.I18n ?>" />              
											</div>
										</div>
									</div>
								</div>
							</div>

							<?php
							wp_nonce_field( $this->plugin->name, $this->plugin->name . '_nonce' );
							?>
						</div>
						<!-- /normal-sortables -->
					</div>
					<!-- /post-body-content -->
				</div>
			</div> 
			<!-- /poststuff -->
		</form>
	</div>
</div>
